require( "scripts/chocshopstyle.lua" );
require( "scripts/transitions.lua" );

-- Initializes the current screen variable
kCurrentScreen = 0;
totalScreens = 10;

dialogW = 515;
dialogH = 380;
margin  = 40;

HelpTextStyle = {
    font = {edwardian_medium, 15, WhiteColor},
};

MakeDialog
{
	name = "help",
	
	VTintWindow{
	    x = 0, 
	    y = 0, 
	    w = 800, 
	    h = 600,
	    color = Color(0,0,0,200),
	    time = 300,
	    fade = true,
	},
	
	RBounceWindow
	{
	    name        = "bounce_container",
	    x           = 800 + dialogW,
	    y           = 0,
	    w           = dialogW,
	    h           = 600,
	    targetposx  = 400 - dialogW/2,
	    targetposy  = 0,
	    bouncelen	= 300,
		bouncefunc	= "sincx",
		alpha       = true,
		
	    KSplit9Image{
		    x		= 0,
		    y		= 300 - dialogH/2,
		    w       = dialogW,
		    h       = dialogH,
		    x1      = 30, 
		    y1      = 32,
            x2      = 37, 
            y2      = 40,
		    image	= "ui/backgrounds/split9_dialog_small",
		
		    VHelpWindow{
		        x = 0,
		        y = 0,
		        w = kMax,
		        h = kMax,
		        
		        SetStyle(HelpTextStyle),
		        
		        SelectLayer(-1),
		        Text{
		            x = 450, 
		            y = 18,
		            w = 40,
		            h = 18,
		            name = "txt_page",
		            flags = kVAlignCenter + kHAlignCenter,
		        },
		        -------------------------------------------------- Page 1
		        SelectLayer(0),
		        Text{
		            x = 0 + margin, 
		            y = 40,
		            w = kMax - margin,
		            h = 80,
		            flags = kVAlignCenter + kHAlignCenter,
		            label = "help_1_1",
		        },
		        Text{
		            x = 175, 
		            y = 120,
		            w = kMax - 175,
		            h = 190,
		            flags = kVAlignCenter + kHAlignLeft,
		            font = {edwardian_medium, 20, WhiteColor},
		            label = "help_1_2",
		        },
		        -------------------------------------------------- Page 2
		        SelectLayer(1),
		        Bitmap{
		            x = 340,
		            y = 33,
		            image = "ui/help/help2_1",
		        },
		        Bitmap{
		            x = 62,
		            y = 109,
		            image = "ui/help/help2_2",
		        },
		        Bitmap{
		            x = 352,
		            y = 231,
		            image = "ui/help/help2_3",
		        },
		        Text{
		            x = 0 + margin, 
		            y = 33,
		            w = 340 - margin*2,
		            h = 109-33,
		            flags = kVAlignCenter + kHAlignLeft,
		            label = "help_2_1",
		        },
		        Text{
		            x = 180 + margin, 
		            y = 140,
		            w = kMax - margin,
		            h = 231 - 140,
		            flags = kVAlignCenter + kHAlignLeft,
		            label = "help_2_2",
		        },
		        Text{
		            x = 0 + margin, 
		            y = 240,
		            w = 352 - margin*2,
		            h = 300 - 240,
		            flags = kVAlignCenter + kHAlignLeft,
		            label = "help_2_3",
		        },
		        -------------------------------------------------- Page 3
		        SelectLayer(2),
		        Bitmap{
		            x = 326,
		            y = 72,
		            image = "ui/help/help3_1",
		        },
		        Bitmap{
		            x = 326,
		            y = 197,
		            image = "ui/help/help3_2",
		        },
		        Text{
		            x = 0 + margin, 
		            y = 20,
		            w = kMax - margin,
		            h = 80 - 20,
		            flags = kVAlignCenter + kHAlignCenter,
		            label = "help_3_1",
		        },
		        Text{
		            x = 0 + margin, 
		            y = 90,
		            w = 326 - margin*2,
		            h = 92,
		            flags = kVAlignCenter + kHAlignLeft,
		            label = "help_3_2",
		        },
		        Text{
		            x = 0 + margin, 
		            y = 206,
		            w = 326 - margin*2,
		            h = 92,
		            flags = kVAlignCenter + kHAlignLeft,
		            label = "help_3_3",
		        },
		        -------------------------------------------------- Page 4
		        SelectLayer(3),
		        Bitmap{
		            x = 326,
		            y = 47,
		            image = "ui/help/help4_1",
		        },
		        Bitmap{
		            x = 326,
		            y = 186,
		            image = "ui/help/help4_2",
		        },
		        Text{
		            x = 0 + margin, 
		            y = 20,
		            w = 326 - margin*2,
		            h = 145,
		            flags = kVAlignCenter + kHAlignLeft,
		            label = "help_4_1",
		        },
		        Text{
		            x = 0 + margin, 
		            y = 165,
		            w = 326 - margin*2,
		            h = 145,
		            flags = kVAlignCenter + kHAlignLeft,
		            label = "help_4_2",
		        },
		        -------------------------------------------------- Page 5
		        SelectLayer(4),
		        Bitmap{
		            x = 326,
		            y = 55,
		            image = "ui/help/help5_1",
		        },
		        Bitmap{
		            x = 326,
		            y = 190,
		            image = "ui/help/help5_2",
		        },
		        Text{
		            x = 0 + margin, 
		            y = 55,
		            w = 326 - margin*2,
		            h = 125,
		            flags = kVAlignCenter + kHAlignLeft,
		            label = "help_5_1",
		        },
		        Text{
		            x = 0 + margin, 
		            y = 184,
		            w = 326 - margin*2,
		            h = 108,
		            flags = kVAlignCenter + kHAlignLeft,
		            label = "help_5_2",
		        },
		        -------------------------------------------------- Page 6
		        SelectLayer(5),
		        Bitmap{
		            x = 326,
		            y = 105,
		            image = "ui/help/help6_1",
		            Text{
		                x = 60,
		                y = 55,
		                w = 60,
		                h = 50,
		                --label = "#+++",
		                font = {edwardian_medium, 15, FColor(1.0,1.0,0)},
		                --label = "help_combo",
		                label = "#<outline color='000000' size=2>"..GetString("combo_menu").." x1<br>$3</outline>",
		                flags = kHAlignCenter + kVAlignTop,
		            }
		        },
		        Text{
		            x = 0 + margin, 
		            y = 30,
		            w = 326 - margin*2,
		            h = 270,
		            flags = kVAlignCenter + kHAlignLeft,
		            label = "help_6_1",
		        },
		        -------------------------------------------------- Page 7
		        SelectLayer(6),
		        Bitmap{
		            x = 357,
		            y = 45,
		            image = "ui/help/help7_1",
		        },
		        Bitmap{
		            x = 290,
		            y = 180,
		            image = "ui/help/help7_2",
		        },
		        Text{
		            x = 0 + margin, 
		            y = 45,
		            w = 357 - margin*2,
		            h = 120,
		            flags = kVAlignCenter + kHAlignLeft,
		            label = "help_7_1",
		        },
		        Text{
		            x = 0 + margin, 
		            y = 180,
		            w = 300 - margin*2,
		            h = 115,
		            flags = kVAlignCenter + kHAlignLeft,
		            label = "help_7_2",
		        },
		         -------------------------------------------------- Page 8
		        SelectLayer(7),
		        Bitmap{
		            x = 352,
		            y = 126,
		            image = "ui/help/help8_1",
		        },
		        Text{
		            x = 0 + margin, 
		            y = 15,
		            w = kMax - margin,
		            h = 126 - 15,
		            flags = kVAlignCenter + kHAlignCenter,
		            label = "help_8_1",
		        },
		        Text{
		            x = 0 + margin, 
		            y = 126,
		            w = 312 - margin*2,
		            h = 170,
		            flags = kVAlignCenter + kHAlignLeft,
		            label = "help_8_2",
		        },
		        -------------------------------------------------- Page 9
		        SelectLayer(8),
		        Bitmap{
		            x = 347,
		            y = 40,
		            image = "ui/help/help9_1",
		        },
		        Bitmap{
		            x = 76,
		            y = 153,
		            image = "ui/help/help9_2",
		        },
		        Text{
		            x = 0 + margin, 
		            y = 30,
		            w = 317 - margin*2,
		            h = 120,
		            flags = kVAlignCenter + kHAlignLeft,
		            label = "help_9_1",
		        },
		        Text{
		            x = 175 + margin, 
		            y = 153 + 30,
		            w = kMax - margin,
		            h = 120,
		            flags = kVAlignCenter + kHAlignLeft,
		            label = "help_9_2",
		        },
		        -------------------------------------------------- Page 10
		        SelectLayer(9),
		        Bitmap{
		            x = 144,
		            y = 141,
		            image = "ui/help/help10_1",
		        },
		        Text{
		            x = 0 + margin, 
		            y = 20,
		            w = kMax - margin,
		            h = 144 - 15,
		            flags = kVAlignCenter + kHAlignCenter,
		            label = "help_10_1",
		        },
		        SelectLayer(-1),
	            ---------------------------------------------- Back
			    SetStyle( CSOvalRedButtonStyle ),
			    RDisableButton
			    {
				    x		= kCenter - 140,
				    y		= kMax - 80,
				    --label	= "app_back",
				    name	= "btn_back",
				    SelectLayer(3),
				    RWindow{
				        image = "ui/buttons/oval_red_up",
				        imagealpha = 0.2,
				    },
				    SelectLayer(-1),
			        Text{
			            w = kMax,
			            h = kMax,
			            label = "app_back",
			        }
			    },
    			
			    ---------------------------------------------- Next
			    SetStyle( CSOvalGreenButtonStyle ),
			    RDisableButton
			    {
				    x		= kCenter + 140,
				    y		= kMax - 80,
				    --label	= "app_next",
				    name	= "btn_next",
				    SelectLayer(3),
				    RWindow{
				        image = "ui/buttons/oval_green_up",
				        imagealpha = 0.2,
				    },
				    SelectLayer(-1),
			        Text{
			            w = kMax,
			            h = kMax,
			            label = "app_next",
			        }
			    },
			    
			    ---------------------------------------------- Close
			    SetStyle( CSOvalLightBlueButtonStyle ),
			    Button
			    {
				    x		= kCenter,
				    y		= kMax - 80,
				    label	= "app_close",
				    name	= "btn_close",
				    command = 
				        function()
				            SetState("HelpScreenTime", 0);
                            SetState("MainMenuScreenTime", 1);
				            PostMessage( CreateNamedMessage( kTintOff, "" ) );
				            DoTransition( kBounceThrough );
				            CloseWindow();
				        end
			    },
	        },
		},
		KSplit9Image{
		    name    = "header_box",
		    x		= kCenter,
		    y		= 80,
		    w       = 280,
		    h       = 65,
		    x1      = 30, 
		    y1      = 32,
            x2      = 37, 
            y2      = 40,
		    image	= "ui/backgrounds/split9_dialog_small",
		    
		    Text{
		        name = "txt_title",
		        x = 0,
		        y = 0,
		        w = 280,
		        h = 65,
		        flags = kVAlignCenter + kHAlignCenter,
		        font = {edwardian_medium, 28, WhiteColor},
		        label = "#no_title",
		    },
		}
	}
}
SetPage(0);

-- Do Metrics
SetState("HelpScreenTime", 1);
SetState("MainMenuScreenTime", 0);